###  **1、支持的PLC变量类型**
```shell
    ST_BOOL 
    ST_BYTE 
    ST_WORD 
    ST_DWORD
    ST_LWORD
    ST_SINT
    ST_USINT
    ST_INT
    ST_UINT
    ST_DINT
    ST_UDINT
    ST_LINT
    ST_REAL
    ST_LREAL
    ST_STRING
```

---
### **2、初始化一个设备的连接句柄**
```shell
/**
 * @brief      创建一个连接
 * ConnParam   连接参数结构体
 * return:     成功返回handler的句柄，失败返回nullptr
 */
TAG_HANDER AcpCreatConnHandler(ConnParam* pConnParam);
```


---
### **3、读取变量**

```shell
/**
 * @brief       读取变量
 * handler:     连接句柄
 * taginfo：    变量信息结构体，包含变量路径，读取变量地址和大小
 * nTimeOutMs:  超时时间ms
 * tagNum:      读取列表数量
 * return:      成功返回0,失败返回-1或者错误码
 */ 
int AcpReadTagValue(TAG_HANDER handler,TagInfo* taginfo,int nTimeOutMs);//读单一变量
int AcpReadTagList(TAG_HANDER handler,TagInfo* taginfo,int tagNum,int nTimeOutMs);//读变量列表
```

---
### **4、写入变量**

```shell
/**
 * @brief       写入变量
 * handler:     连接句柄
 * taginfo：    变量信息结构体，包含变量路径，读取变量地址和大小
 * nTimeOutMs:  超时时间ms
 * tagNum:      读取列表数量
 * return:      成功返回0,失败返回-1或者错误码
 */ 
int AcpWriteTagValue(TAG_HANDER handler,TagInfo* taginfo,int nTimeOutMs);//写单一变量
int AcpWriteTagList(TAG_HANDER handler,TagInfo* taginfo,int tagNum,int nTimeOutMs);//写变量列表
```
---
### **5、注册回调函数**
```shell
/**
* @brief       注册回调函数
* handler：    连接句柄
* NotifyCallback： 注册的回调函数名称
* lpContext：通用指针，允许你传递一个上下文数据到回调函数中
* return：   成功返回0,失败返回-1或者错误码
*/
int AcpRegisterNotifyCallBack(TAG_HANDER handler,pfnNotifyCallback NotifyCallback,void* lpContext);
```
---
### **6、移除回调函数**
```shell
/**
* @brief     移除订阅回调
* handler：  连接句柄
* return:    成功返回0,失败返回-1或者错误码
*/
int AcpRemoveNotifyCallBack(TAG_HANDER handler); 
```
---
### **7、添加变量组订阅**
```shell
/**
* @brief      添加变量组订阅
* handler：   连接句柄
* taginfo：   变量信息结构体，包含订阅变量路径
* tagNum：    订阅变量数量
* nTimeOutMs: 超时时间ms
* return:     成功返回true,失败返回false
*/
int AcpAddTagsNotification(TAG_HANDER handler,TagValue* taginfo,
int tagNum,TagSubParam* pSubParam,int nTimeOutMs);
```